import random
from main import *
from oracle import *
import datetime
import numpy
import math
import pymultinode

now = datetime.datetime.now()
month = str(now.month)
day = str(now.day)
hour = str(now.hour)

def run(swarmSize,new = True):

    log = file("log"+str(swarmSize)+".txt",'w')
    fitFile = file("fit"+str(swarmSize)+".txt",'w')
    fitFile2 = file("Fitness_Scores"+str(swarmSize)+".txt",'w')
    list_file = file("list"+str(swarmSize)+".txt",'w')

    print >> fitFile2, swarmSize
    teams = []
    numTeams = 20 # quarter of the total teams tested
    #swarmSize = 25
    if new:
        for i in range(2*numTeams):
            teams.append(Team())
    else:
        team_file = file('team_list.txt','r')
        for line in team_file:
            weights = eval(line)
            teams.append(Team(new,weights))

##    mines_found = []
##    timeList = []
##    swarm_left = []
    max_mines = []
    avg_mines = []
    min_mines = []
    max_mines_f = []
    avg_mines_f = []
    min_mines_f = []
    max_time = []
    avg_time = []
    min_time = []
    max_swarm = []
    avg_swarm = []
    min_swarm = []
    max_fit = []
    avg_fit = []
    min_fit = []

    lb = 0.0
    generations = 500
    Threshold = [0.9,0.9,0.95]
    processor = pymultinode.JobProcessor('unicorn','dd05.ecs.baylor.edu')
    for g in range(generations):
        mines_g = []
        mines_g_f = []
        time_g = []
        swarm_g = []
        fit_g = []
        n = 0
        games = []

        new_teams = []
        for t in teams:
            if t.num > (g*numTeams) and t.num > numTeams:
                new_teams.append(t.step_size)
        avg = []
        for i in range(len(teams[0].w)):
            avg.append(0)
        for s in new_teams:
            for i in range(len(s)):
                avg[i] += s[i]
        if len(new_teams) > 0:
            for i in range(len(avg)):
                avg[i] = avg[i]/float(len(new_teams))
        lb = abs(numpy.median(avg))

        for t in teams[0:numTeams]:
            w = t.w[:]
            teams.append(Team(False,w))
        for t in range(numTeams):
            teams.append(Team())
        steps = []
        for t in teams[len(teams)//2:]:
            steps.append(t.mutate(lb))

        for t in teams:
            t.fitness = []
            t.mines = []
            t.mines_f = []
            t.time = []
            t.swarm = []
            num_games = 10
            for i in range(num_games):
                games.append(t)
        game_results = []
        for team in games:
            graphics = False
##            n += 1
##            if n == 1:
##                graphics = True
            print "Team", team.num, "playing"
##            game_results.append(playgame(team,graphics,swarmSize))
##            print team.num
##            print len(team.w)
            game_results.append(processor.request(playgame,team,graphics,swarmSize))
        for team,result in zip(games, game_results):
            result = result.wait()
            [time,mines_f,mines,swarm] = result
##            team.fitness.append((mines+mines_f+swarm+float(time/2000.0))*100)
            if mines_f < Threshold[0]:
                a = mines_f
            else:
                a = Threshold[0]
            if mines < Threshold[1]:
                b = mines
            else:
                b = Threshold[1]
            if swarm < Threshold[2]:
                c = swarm
            else:
                c = Threshold[2]
            team.fitness.append((1+a)*(1+b)*(1+c)*(1+(time/2000.0)))
            team.mines_f.append(mines_f)
            team.mines.append(mines)
            team.time.append(time)
            team.swarm.append(swarm)

        for t in teams:
            t.average_time = numpy.average(t.time)
            t.average_mines = numpy.average(t.mines)
            t.average_swarm = numpy.average(t.swarm)
            t.average_mines_f = numpy.average(t.mines_f)
            t.average_fitness = numpy.average(t.fitness)
            if t.average_mines_f < Threshold[0]:
                a = t.average_mines_f
            else:
                a = Threshold[0]
            if t.average_mines < Threshold[1]:
                b = t.average_mines
            else:
                b = Threshold[1]
            if t.average_swarm < Threshold[2]:
                c = t.average_swarm
            else:
                c = Threshold[2]
            t.fitness_average = (1+a)*(1+b)*(1+c)*(1+(t.average_time/2000.0))
            print t.average_mines,t.average_swarm,t.average_mines_f, t.average_fitness
##            t.min = min(t.average_mines,t.average_swarm,t.average_mines_f)
##            t.average = numpy.average([t.average_swarm,t.average_mines,t.average_mines_f])
##            t.max = max(t.average_mines,t.average_swarm,t.average_mines_f)
##        for t in teams:
##            t.points = 0
##            for i in range(10):
##                opponent = random.choice(teams)
##                if t.average_mines > opponent.average_mines:
##                    t.points += 1
##                elif t.average_mines > (opponent.average_mines-1):
##                    if t.average_mines_f > opponent.average_mines_f:
##                        t.points += 1
##                    elif t.average_mines_f > (opponent.average_mines_f-1):
##                        if t.average_swarm > opponent.average_swarm:
##                            t.points += 1
##                        elif t.average_swarm > (opponent.average_swarm-.1):
##                            if t.average_time > opponent.average_time:
##                                t.points += 1
        for t in teams:
            t.points = 0
            for i in range(10):
                opponent = random.choice(teams)
##                fit1 = t.average_mines + t.average_swarm + t.average_mines_f + float(t.average_time/2000.0)
##                fit2 = opponent.average_mines + opponent.average_swarm + opponent.average_mines_f + float(opponent.average_time/2000.0)
##                fit1 = t.fitness
##                fit2 = opponent.fitness
                fit1 = t.average_fitness
                fit2 = opponent.average_fitness
                if t.average_mines_f > 0:
                    Found1 = True
                else:
                    Found1 = False
                if opponent.average_mines_f > 0:
                    Found2 = True
                else:
                    Found2 = False
                if t.average_mines > 0:
                    Report1 = True
                else:
                    Report1 = False
                if opponent.average_mines > 0:
                    Report2 = True
                else:
                    Report2 = False
                if Report1 and not Report2:
                    t.points += 1
                elif Report1 == Report2:
                    if Found1 and not Found2:
                        t.points += 1
                    elif Found1 == Found2:
                        if fit1 > fit2:
                            t.points += 1
##                        elif fit1 == fit2:
##                            if t.average_time > opponent.average_time:
##                                t.points += 1

##                if t.min > opponent.min:
##                    t.points += 1
##                elif t.min == opponent.min:
##                    if t.average > opponent.average:
##                        t.points += 1
##                    elif t.average == opponent.average:
##                        if t.max > opponent.max:
##                            t.points += 1
##                        elif t.max == opponent.max:
##                            if t.average_time > opponent.average_time:
##                                t.points += 1


        teams.sort(key = lambda team:-team.points)

        for t in teams:
            print t.num, t.average_mines_f, t.average_mines, t.average_swarm, t.average_time, t.average_fitness

        del teams[len(teams)//2:]

        for t in teams:
            mines_g_f.append(round(t.average_mines_f,2))
            mines_g.append(round(t.average_mines,2))
            swarm_g.append(round(t.average_swarm,2))
            time_g.append(round(t.average_time,2))
            fit_g.append(round(t.fitness_average,2))

        print mines_g_f
        print mines_g
        print swarm_g
        print time_g
        max_mines.append(round(max(mines_g),2))
        avg_mines.append(round(numpy.average(mines_g),2))
        min_mines.append(round(min(mines_g),2))
        max_mines_f.append(round(max(mines_g_f),2))
        avg_mines_f.append(round(numpy.average(mines_g_f),2))
        min_mines_f.append(round(min(mines_g_f),2))
        max_swarm.append(round(max(swarm_g),2))
        avg_swarm.append(round(numpy.average(swarm_g),2))
        min_swarm.append(round(min(swarm_g),2))
        max_time.append(round(max(time_g),2))
        avg_time.append(round(numpy.average(time_g),2))
        min_time.append(round(min(time_g),2))
        max_fit.append(round(max(fit_g),2))
        avg_fit.append(round(numpy.average(fit_g),2))
        min_fit.append(round(min(fit_g),2))

        print >> fitFile, '\n', g
        print >> fitFile2, '\n', g
        print >> fitFile, max_mines_f
        print >> fitFile, avg_mines_f
        print >> fitFile, min_mines_f
        print >> fitFile, max_mines
        print >> fitFile, avg_mines
        print >> fitFile, min_mines
        print >> fitFile, max_swarm
        print >> fitFile, avg_swarm
        print >> fitFile, min_swarm
        print >> fitFile, max_time
        print >> fitFile, avg_time
        print >> fitFile, min_time
        print >> fitFile2, max_fit
        print >> fitFile2, avg_fit
        print >> fitFile2, min_fit
        print >> log, "\nGeneration", g+1
        print >> list_file, "\nGeneration", g+1
        for t in teams:
            print t.num,round(numpy.average(t.mines),2),round(numpy.average(t.swarm),2),round(numpy.average(t.time),2)
            print >> log, "Team number:", t.num
            temp = t.w[:]
            temp_a = t.adapt[:]
            for i in range(len(temp)):
                temp[i] = round(temp[i],2)
                temp_a[i] = round(temp_a[i],2)
            print >> log, "Mines found:", t.mines, round(numpy.average(t.mines_f),2)
            print >> log, "Mines reported:", t.mines, round(numpy.average(t.mines),2)
            print >> log, "Swarm left:", t.swarm, round(numpy.average(t.swarm),2)
            print >> log, "Time left:", t.time, round(numpy.average(t.swarm),2)
            print >> log, "Weights:", temp
            print >> log, "Adaptive Parameters:", temp_a
            print >> log, lb
            print >> list_file, temp
        log.flush()
        fitFile.flush()
        fitFile2.flush()
        list_file.flush()

    log.close()
    fitFile.close()
    fitFile2.close()
    list_file.close()








class Team():
    num = 0
    def __init__(self,new=True,weights=[]):
        Team.num += 1
        self.num = Team.num
        self.adapt = []
        for i in range(57):
            self.adapt.append(1.25)
        for i in range(3):
            self.adapt.append(75.0)
        for i in range(3):
            self.adapt.append(12.5)
##        for i in range(2):
##            self.adapt.append(50)
        for i in range(9):
            self.adapt.append(0.25)
        for i in range(3):
            self.adapt.append(0.75)
        self.step_size = [0]*len(self.adapt)
        if new:
            self.w = []
            self.fitness = []
            for i in range(57):
                self.w.append(random.randint(-5,5))
            for i in range(3):
                self.w.append(random.randint(1,600))
            for i in range(3):
                self.w.append(random.randint(1,100))
##            for i in range(2):
##                self.w.append(random.randint(1,400))
            for i in range(9):
                self.w.append(random.randint(-1,1))
            for i in range(3):
                self.w.append(random.randint(-3,3))
        else:
            self.w = weights[:]
            self.fitness = []

    def mutate(self,lb):
        step_size = []
        n = float(len(self.w))
        tau = 1/(math.sqrt(2*math.sqrt(n)))
        for i in range(57):
            Nj = random.gauss(0,1)
            self.adapt[i] *= math.exp(tau*Nj)
            if self.adapt[i] > 10.0:
                self.adapt[i] = 10.0
            elif self.adapt[i] < lb:
                self.adapt[i] = lb
            step_size.append(abs(self.adapt[i]*Nj))
            self.w[i] += (self.adapt[i]*Nj)
            if self.w[i] > 5.0:
                self.w[i] = 5.0
            elif self.w[i] < -5.0:
                self.w[i] = -5.0
        for i in range(3):
            Nj = random.gauss(0,1)
            self.adapt[i+57] *= math.exp(tau*Nj)
            if self.adapt[i+57] > 600.0:
                self.adapt[i+57] = 600.0
            elif self.adapt[i+57] < lb:
                self.adapt[i+57] = lb
            step_size.append(abs(self.adapt[i+57]*Nj)/60.0)
            self.w[i+57] += (self.adapt[i+57]*Nj)
            if self.w[i+57] > 600.0:
                self.w[i+57] = 600.0
            elif self.w[i+57] < 1.0:
                self.w[i+57] = 1.0
        for i in range(3):
            Nj = random.gauss(0,1)
            self.adapt[i+60] *= math.exp(tau*Nj)
            if self.adapt[i+60] > 100.0:
                self.adapt[i+60] = 100.0
            elif self.adapt[i+60] < lb:
                self.adapt[i+60] = lb
            step_size.append(abs(self.adapt[i+60]*Nj)/10.0)
            self.w[i+60] += (self.adapt[i+60]*Nj)
            if self.w[i+60] > 100.0:
                self.w[i+60] = 100.0
            elif self.w[i+60] < 1.0:
                self.w[i+60] = 1.0
##        for i in range(2):
##            Nj = random.gauss(0,1)
##            self.adapt[i+63] *= math.exp(tau*Nj)
##            if self.adapt[i+63] > 400:
##                self.adapt[i+63] = 400
##            elif self.adapt[i+63] < lb:
##                self.adapt[i+63] = lb
##            step_size.append(abs(self.adapt[i+63]*Nj))
##            self.w[i+63] += (self.adapt[i+63]*Nj)
##            if self.w[i+63] > 400.0:
##                self.w[i+63] = 400.0
##            elif self.w[i+63] < 1.0:
##                self.w[i+63] = 1.0
        for i in range(9):
            Nj = random.gauss(0,1)
            self.adapt[i+63] *= math.exp(tau*Nj)
            if self.adapt[i+63] > 2.0:
                self.adapt[i+63] = 2.0
            elif self.adapt[i+63] < lb:
                self.adapt[i+63] = lb
            step_size.append(abs(self.adapt[i+63]*Nj)*5.0)
            self.w[i+63] += (self.adapt[i+63]*Nj)
            if self.w[i+63] > 1.0:
                self.w[i+63] = 1.0
            elif self.w[i+63] < -1.0:
                self.w[i+63] = -1.0
        for i in range(3):
            Nj = random.gauss(0,1)
            self.adapt[i+72] *= math.exp(tau*Nj)
            if self.adapt[i+72] > 6:
                self.adapt[i+72] = 6
            elif self.adapt[i+72] < lb:
                self.adapt[i+72] = lb
            step_size.append(abs(self.adapt[i+72]*Nj)*1.67)
            self.w[i+72] += (self.adapt[i+72]*Nj)
            if self.w[i+72] > 3.0:
                self.w[i+72] = 3.0
            elif self.w[i+72] < -3.0:
                self.w[i+72] = -3.0
        self.step_size = step_size[:]
        return step_size

if __name__=='__main__':
    try:
        run(35)
        run(45)
        run(50)
    except Exception as error:
        if hasattr(error, 'original_traceback'):
            print error.original_traceback
        raise















